import fs from 'fs';
import path from 'path';
import { fileURLToPath } from 'url';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

const answerKeysPath = path.join(__dirname, '../client/src/lib/answerKeys.json');
const outputPath = path.join(__dirname, '../attached_assets/answerKeys.csv');

const answerKeys = JSON.parse(fs.readFileSync(answerKeysPath, 'utf-8'));

const rows = [];
rows.push(['Level', 'LevelName', 'Focus', 'QuestionID', 'Type', 'Gleams', 'Alicorns', 'Stakeholder', 'Question', 'Grade1', 'Grade2', 'Grade3', 'Grade4', 'Grade5']);

for (const [levelId, levelData] of Object.entries(answerKeys)) {
  const levelName = levelData.levelName || '';
  const focus = levelData.focus || '';
  const questions = levelData.questions || {};
  
  for (const [questionId, questionData] of Object.entries(questions)) {
    const type = questionData.type || '';
    const gleams = questionData.gleams || 0;
    const alicorns = questionData.alicorns || 0;
    const stakeholders = questionData.stakeholders || {};
    
    for (const [stakeholder, stakeholderData] of Object.entries(stakeholders)) {
      const question = stakeholderData.question || '';
      const grades = stakeholderData.grades || {};
      
      const grade1 = grades['1'] || '';
      const grade2 = grades['2'] || '';
      const grade3 = grades['3'] || '';
      const grade4 = grades['4'] || '';
      const grade5 = grades['5'] || '';
      
      rows.push([
        levelId,
        levelName,
        focus,
        questionId,
        type,
        gleams,
        alicorns,
        stakeholder,
        question,
        grade1,
        grade2,
        grade3,
        grade4,
        grade5
      ]);
    }
  }
}

function escapeCSV(value) {
  if (value === null || value === undefined) return '';
  const str = String(value);
  if (str.includes(',') || str.includes('"') || str.includes('\n') || str.includes('\r')) {
    return '"' + str.replace(/"/g, '""') + '"';
  }
  return str;
}

const csvContent = rows.map(row => row.map(escapeCSV).join(',')).join('\n');

fs.mkdirSync(path.dirname(outputPath), { recursive: true });
fs.writeFileSync(outputPath, csvContent, 'utf-8');

console.log(`CSV exported to: ${outputPath}`);
console.log(`Total rows: ${rows.length - 1} (excluding header)`);
