const fs = require('fs');
const path = require('path');

const answerKeysPath = path.join(__dirname, '../client/src/lib/answerKeys.json');
const answerKeys = JSON.parse(fs.readFileSync(answerKeysPath, 'utf-8'));

const STAKEHOLDER = "Enabler (Accelerator)";

const allUpdates = {
  L0: {
    D1: {
      "1": "We offer no safety; high risk for founders.",
      "2": "We offer a space, but it lacks structure.",
      "3": "We provide a sandbox where learning happens.",
      "4": "We provide a structured, safe environment.",
      "5": "We provide a legendary safe space where founders thrive."
    },
    D2: {
      "1": "High stakes; we punish failure.",
      "2": "Some safety, but fear of failure remains.",
      "3": "Safe to experiment; failures normalized.",
      "4": "Deep psychological safety; courage visible.",
      "5": "Legendary enabling of vulnerability; culture shift."
    },
    D3: {
      "1": "Programs misaligned; we stress founders.",
      "2": "Some resilience focus; incomplete curriculum.",
      "3": "Clear resilience curriculum offered.",
      "4": "Deep resilience program; mentor-supported.",
      "5": "Legendary resilience program; transforms lives."
    },
    D4: {
      "1": "Programs failed; alumni struggled.",
      "2": "Limited success; unclear model.",
      "3": "Several successful cohorts; learning pattern.",
      "4": "Proven model; alumni thriving.",
      "5": "Legendary program; top-tier alumni performance."
    },
    D5: {
      "1": "No resources; cannot support effectively.",
      "2": "Limited resources; insufficient runway.",
      "3": "Resources available; can help significantly.",
      "4": "Well-resourced; real financial support.",
      "5": "Legendary resources; founder-supported fully."
    },
    D6: {
      "1": "No mental health support; missing.",
      "2": "Basic mental health resources listed.",
      "3": "Dedicated resilience program included.",
      "4": "Deep mental health; therapy-integrated.",
      "5": "Legendary for well-being; we transform founders."
    },
    D7: {
      "1": "Isolated founders; competitive atmosphere.",
      "2": "Some networking; limited bonding.",
      "3": "Real community; founders help each other.",
      "4": "Strong community; lifelong alumni bonds.",
      "5": "Legendary community; the gold standard of networks."
    },
    D8: {
      "1": "Short-term grant/hype dependent.",
      "2": "Unclear longevity; burnout risks.",
      "3": "Sustainable for 2–3 years.",
      "4": "Sustainable for 5–10 years; robust.",
      "5": "Lifelong commitment; crisis-resistant institution."
    },
    D9: {
      "1": "We exploit founders for our brand.",
      "2": "We try to help, but our needs come first.",
      "3": "We balance founder needs with ours.",
      "4": "We are deeply committed to founder success.",
      "5": "We are radically founder-first; legendary loyalty."
    },
    EiR1: {
      "1": "We chase hype; quality suffers.",
      "2": "Mix of hype and substance.",
      "3": "Balanced coverage of hype/real.",
      "4": "Substance-focused; hype-resistant.",
      "5": "Legend for substance; authentic focus."
    },
    EiR2: {
      "1": "Conflicts tear apart cohort.",
      "2": "Some conflict; navigates poorly.",
      "3": "Addresses proactively; mediation.",
      "4": "Excellent cohort dynamics management.",
      "5": "Legend for healthy communities."
    },
    EiR3: {
      "1": "Cronies get preferential treatment.",
      "2": "Some favoritism exists.",
      "3": "Mostly fair allocation.",
      "4": "Rigorous fairness mechanisms.",
      "5": "Legendary integrity; blind to bias."
    },
    EiR4: {
      "1": "Criteria highly biased; exclusionary.",
      "2": "Some unconscious bias exists.",
      "3": "Relatively unbiased criteria.",
      "4": "Carefully unbiased selection.",
      "5": "Legend for fair inclusion; diversity native."
    },
    EiR5: {
      "1": "Inflates expectations wildly.",
      "2": "Occasional inflation of results.",
      "3": "Realistic expectations set.",
      "4": "Carefully manages expectations.",
      "5": "Legend for accuracy and trust."
    },
    EiR6: {
      "1": "Multiple critical barriers exist.",
      "2": "Some barriers unaddressed.",
      "3": "Trying to remove barriers.",
      "4": "Active barrier removal program.",
      "5": "Legend for inclusion; zero barriers."
    },
    EiR7: {
      "1": "Breaks down easily; defensive.",
      "2": "Gets defensive often.",
      "3": "Can take criticism constructively.",
      "4": "Welcomes criticism for growth.",
      "5": "Thrives on criticism; antifragile."
    },
    EiR8: {
      "1": "Staff frustrated/cynical.",
      "2": "Some staff frustration.",
      "3": "Mostly inspired staff.",
      "4": "Well-inspired, energetic staff.",
      "5": "Legendary staff culture; mission-driven."
    },
    EiR9: {
      "1": "Pure ego/power/profit.",
      "2": "Mostly power/status.",
      "3": "Mixed motives (mission + sustain).",
      "4": "Mostly mission; some sustain.",
      "5": "Pure mission-driven; ecosystem stewardship."
    }
  },
  L1: {
    D1: {
      "1": "No applicants; we beg founders.",
      "2": "Low quality/volume applications.",
      "3": "Good volume; mixed quality.",
      "4": "High volume; high quality.",
      "5": "We turn away unicorns; legendary demand."
    },
    D2: {
      "1": "Random selection; no criteria.",
      "2": "Vague criteria; gut feel.",
      "3": "Structured selection process.",
      "4": "Data-driven predictive selection.",
      "5": "Legendary eye for talent; unmatched hit rate."
    },
    D3: {
      "1": "We do not help; assume validation.",
      "2": "Basic advice on validation.",
      "3": "Structured validation curriculum.",
      "4": "Hands-on validation sprints.",
      "5": "Legendary validation methodology."
    },
    D4: {
      "1": "No mentors; just staff.",
      "2": "Friends and family network.",
      "3": "Relevant industry mentors.",
      "4": "High-profile, active mentors.",
      "5": "Legendary mentor network; global icons."
    },
    D5: {
      "1": "Homogeneous; echo chamber.",
      "2": "Token diversity.",
      "3": "Representative diversity.",
      "4": "Intentional, tracked diversity.",
      "5": "Radically diverse; cognitive powerhouse."
    },
    D6: {
      "1": "We accept \"solutions looking for problems.\"",
      "2": "We prefer trendy problems.",
      "3": "We filter for problem-market fit.",
      "4": "We target systemic/hard problems.",
      "5": "We define the problems of the future."
    },
    D7: {
      "1": "Hidden fees/equity grabs.",
      "2": "Vague terms; confusing.",
      "3": "Clear terms; standard deal.",
      "4": "Founder-friendly, transparent terms.",
      "5": "The \"Standard\" deal; universally trusted."
    },
    D8: {
      "1": "Chaos; founders lost.",
      "2": "Disorganized; slow start.",
      "3": "Structured onboarding week.",
      "4": "High-velocity induction.",
      "5": "Life-changing welcome experience."
    },
    D9: {
      "1": "Unknown brand.",
      "2": "Local awareness only.",
      "3": "Regional reputation.",
      "4": "National brand recognition.",
      "5": "Global category king of accelerators."
    },
    EiR1: {
      "1": "Acceptance signals \"desperation.\"",
      "2": "Neutral/No signal.",
      "3": "Positive local signal.",
      "4": "Strong quality signal to investors.",
      "5": "Acceptance guarantees VC interest."
    },
    EiR2: {
      "1": ">10% equity for little value.",
      "2": "High fees + equity.",
      "3": "Standard fair equity (5–7%).",
      "4": "Founder-favorable terms.",
      "5": "Value far exceeds equity cost."
    },
    EiR3: {
      "1": "We promise funding we cannot give.",
      "2": "We imply guarantees.",
      "3": "We are realistic about outcomes.",
      "4": "We under-promise and over-deliver.",
      "5": "Our reputation precedes us; trust is absolute."
    },
    EiR4: {
      "1": "Mentors give bad/conflicting advice.",
      "2": "Mentors are disengaged.",
      "3": "Mentors are vetted/trained.",
      "4": "Mentors are accountable/rated.",
      "5": "Mentors are world-class operators."
    },
    EiR5: {
      "1": "We select people \"like us.\"",
      "2": "Unconscious bias unchecked.",
      "3": "Bias training implemented.",
      "4": "Blind screening processes.",
      "5": "Radical cognitive diversity."
    },
    EiR6: {
      "1": "High burn; unsustainable.",
      "2": "Inefficient operations.",
      "3": "Lean program management.",
      "4": "Optimized operational stack.",
      "5": "Highly efficient; automated workflows."
    },
    EiR7: {
      "1": "We ghost applicants.",
      "2": "Form letter rejections.",
      "3": "Actionable feedback provided.",
      "4": "Personalized coaching for rejects.",
      "5": "Rejection is a valuable learning moment."
    },
    EiR8: {
      "1": "Scouts paid for volume (spam).",
      "2": "Scouts purely volunteer.",
      "3": "Scouts incentivized by quality.",
      "4": "Scouts share in upside/carry.",
      "5": "Global network of incentivized scouts."
    },
    EiR9: {
      "1": "We launch in dying markets.",
      "2": "We chase yesterday's trends.",
      "3": "We are on-trend.",
      "4": "We anticipate market shifts.",
      "5": "We create the market trends."
    }
  },
  L2: {
    D1: {
      "1": "No perks/credits.",
      "2": "Some AWS/Cloud credits.",
      "3": "Comprehensive tech stack perks.",
      "4": "Strategic tech partnerships/integrations.",
      "5": "Exclusive access to beta/proprietary tech."
    },
    D2: {
      "1": "No product help.",
      "2": "Generic \"build it\" advice.",
      "3": "Product management curriculum.",
      "4": "Expert CPO-in-residence.",
      "5": "Legendary product feedback loops."
    },
    D3: {
      "1": "No design help.",
      "2": "Critique only.",
      "3": "Design workshops.",
      "4": "Designers-in-residence.",
      "5": "Award-winning design transformation."
    },
    D4: {
      "1": "No legal support.",
      "2": "Templates only.",
      "3": "Partner law firms (discounted).",
      "4": "In-house legal counsel support.",
      "5": "Automated, bulletproof IP/Legal stack."
    },
    D5: {
      "1": "No talent help.",
      "2": "Ad hoc introductions.",
      "3": "Co-founder matching events.",
      "4": "Talent database access.",
      "5": "Pipeline of vetted co-founders/CTOs."
    },
    D6: {
      "1": "No customer access.",
      "2": "Demo day only.",
      "3": "Customer introduction program.",
      "4": "Pilot customer pipeline.",
      "5": "Guaranteed first customers."
    },
    D7: {
      "1": "No testing support.",
      "2": "Basic feedback sessions.",
      "3": "User testing workshops.",
      "4": "Professional UX research.",
      "5": "Integrated product-market fit engine."
    },
    D8: {
      "1": "No office/facilities.",
      "2": "Hot desks only.",
      "3": "Dedicated workspace.",
      "4": "Full office + labs.",
      "5": "World-class facilities (e.g., Station F)."
    },
    D9: {
      "1": "> 6 months to MVP.",
      "2": "3–6 months to MVP.",
      "3": "6–12 weeks to MVP.",
      "4": "< 6 weeks to MVP.",
      "5": "MVP in days; rapid iteration."
    }
  },
  L3: {
    D1: {
      "1": "No investor access.",
      "2": "Demo Day only.",
      "3": "Investor intros post-demo.",
      "4": "Active investor relations.",
      "5": "Guaranteed VC meetings; investor magnet."
    },
    D2: {
      "1": "No pitch help.",
      "2": "Template decks.",
      "3": "Pitch coaching sessions.",
      "4": "Professional deck design.",
      "5": "Legendary pitch transformation."
    },
    D3: {
      "1": "No customer traction.",
      "2": "A few pilot customers.",
      "3": "Growing customer base.",
      "4": "Strong early traction.",
      "5": "Breakout traction; market leaders."
    },
    D4: {
      "1": "No revenue.",
      "2": "Pre-revenue.",
      "3": "Early revenue.",
      "4": "Growing revenue.",
      "5": "Revenue legends; category winners."
    },
    D5: {
      "1": "No follow-on funding.",
      "2": "Occasional follow-on.",
      "3": "Good follow-on rate.",
      "4": "High follow-on rate.",
      "5": "90%+ follow-on; legendary track record."
    },
    D6: {
      "1": "Alumni do not help.",
      "2": "Occasional alumni help.",
      "3": "Active alumni network.",
      "4": "Strong alumni community.",
      "5": "Legendary alumni; pay-it-forward culture."
    },
    D7: {
      "1": "No media coverage.",
      "2": "Local press only.",
      "3": "Trade press coverage.",
      "4": "Major media features.",
      "5": "TechCrunch/NYT regular coverage."
    },
    D8: {
      "1": "Program ends; goodbye.",
      "2": "Alumni Slack only.",
      "3": "Ongoing events/support.",
      "4": "Lifetime access to resources.",
      "5": "Lifelong community; generational support."
    },
    D9: {
      "1": "Poor cohort outcomes.",
      "2": "Mixed outcomes.",
      "3": "Good cohort outcomes.",
      "4": "Strong cohort outcomes.",
      "5": "Legendary cohort; unicorn factory."
    }
  },
  L4: {
    D1: {
      "1": "No Series A support.",
      "2": "Intro to VCs only.",
      "3": "Active Series A prep.",
      "4": "Strong Series A track record.",
      "5": "Series A machine; legendary conversion."
    },
    D2: {
      "1": "No international help.",
      "2": "Occasional intros abroad.",
      "3": "International soft-landing support.",
      "4": "Global network active.",
      "5": "Global expansion playbook; legendary reach."
    },
    D3: {
      "1": "Alumni stall post-program.",
      "2": "Some alumni scale.",
      "3": "Good scaling support.",
      "4": "Strong scaling track record.",
      "5": "Legendary scale-up factory."
    },
    D4: {
      "1": "No hiring help.",
      "2": "Job board access.",
      "3": "Recruiting support.",
      "4": "Executive search support.",
      "5": "Talent pipeline; legendary hiring."
    },
    D5: {
      "1": "No corporate access.",
      "2": "Occasional corporate intros.",
      "3": "Corporate partner program.",
      "4": "Strategic corporate pilots.",
      "5": "Corporate innovation partner of choice."
    },
    D6: {
      "1": "No governance help.",
      "2": "Basic board advice.",
      "3": "Board formation support.",
      "4": "Board member introductions.",
      "5": "Legendary board network."
    },
    D7: {
      "1": "No operational help.",
      "2": "Generic scaling advice.",
      "3": "Operational playbooks.",
      "4": "Fractional C-suite access.",
      "5": "World-class operational support."
    },
    D8: {
      "1": "Alumni forgotten.",
      "2": "Annual check-ins.",
      "3": "Quarterly touchpoints.",
      "4": "Ongoing relationship.",
      "5": "Lifelong partnership; legendary loyalty."
    },
    D9: {
      "1": "No unicorns.",
      "2": "One or two successes.",
      "3": "Growing success rate.",
      "4": "Strong unicorn track record.",
      "5": "Legendary; multiple unicorns."
    }
  },
  L5: {
    D1: {
      "1": "Program loses money.",
      "2": "Break-even program.",
      "3": "Profitable program.",
      "4": "High-margin program.",
      "5": "Legendary returns; self-sustaining."
    },
    D2: {
      "1": "Inefficient operations.",
      "2": "Some operational waste.",
      "3": "Lean operations.",
      "4": "Optimized operations.",
      "5": "World-class operational excellence."
    },
    D3: {
      "1": "No portfolio management.",
      "2": "Basic tracking.",
      "3": "Active portfolio management.",
      "4": "Strategic portfolio optimization.",
      "5": "Legendary portfolio management."
    },
    D4: {
      "1": "Alumni do not raise.",
      "2": "Some alumni raise.",
      "3": "Good fundraising support.",
      "4": "Strong fundraising track record.",
      "5": "Legendary; alumni raise easily."
    },
    D5: {
      "1": "No revenue diversification.",
      "2": "Grant-dependent.",
      "3": "Multiple revenue streams.",
      "4": "Diversified, stable revenue.",
      "5": "Legendary financial sustainability."
    },
    D6: {
      "1": "No sponsor value.",
      "2": "Basic sponsor engagement.",
      "3": "Good sponsor value.",
      "4": "Strong sponsor ROI.",
      "5": "Legendary sponsor partnerships."
    },
    D7: {
      "1": "No measurement.",
      "2": "Basic KPIs.",
      "3": "Comprehensive metrics.",
      "4": "Data-driven decisions.",
      "5": "Legendary impact measurement."
    },
    D8: {
      "1": "High program costs.",
      "2": "Average costs.",
      "3": "Competitive costs.",
      "4": "Low costs, high value.",
      "5": "Exceptional value; legendary efficiency."
    },
    D9: {
      "1": "No carry/upside.",
      "2": "Limited upside.",
      "3": "Fair carry structure.",
      "4": "Strong fund returns.",
      "5": "Legendary returns; top-tier performance."
    }
  },
  L6: {
    D1: {
      "1": "No thought leadership.",
      "2": "Occasional content.",
      "3": "Regular thought leadership.",
      "4": "Industry voice.",
      "5": "Legendary thought leader."
    },
    D2: {
      "1": "No innovation in programs.",
      "2": "Copy other programs.",
      "3": "Some innovation.",
      "4": "Regular program innovation.",
      "5": "Legendary program innovation."
    },
    D3: {
      "1": "No ecosystem role.",
      "2": "Participant.",
      "3": "Active contributor.",
      "4": "Ecosystem leader.",
      "5": "Ecosystem architect."
    },
    D4: {
      "1": "No team development.",
      "2": "Basic training.",
      "3": "Staff development programs.",
      "4": "Strong team culture.",
      "5": "Legendary team; talent magnet."
    },
    D5: {
      "1": "No partner network.",
      "2": "Basic partnerships.",
      "3": "Strong partner network.",
      "4": "Strategic partnerships.",
      "5": "Legendary partner ecosystem."
    },
    D6: {
      "1": "Fear-based culture.",
      "2": "Stressful culture.",
      "3": "Good culture.",
      "4": "Strong, healthy culture.",
      "5": "Legendary culture; people thrive."
    },
    D7: {
      "1": "No succession planning.",
      "2": "Key-person dependency.",
      "3": "Some succession planning.",
      "4": "Strong leadership pipeline.",
      "5": "Legendary; mission transcends founders."
    },
    D8: {
      "1": "No alumni leadership.",
      "2": "Alumni occasionally help.",
      "3": "Alumni mentors.",
      "4": "Alumni lead programs.",
      "5": "Alumni run the show; legendary cycle."
    },
    D9: {
      "1": "No industry influence.",
      "2": "Local influence.",
      "3": "Regional influence.",
      "4": "National influence.",
      "5": "Global influence; legendary impact."
    }
  },
  L7: {
    D1: {
      "1": "No unicorns.",
      "2": "One unicorn.",
      "3": "A few unicorns.",
      "4": "Several unicorns.",
      "5": "Legendary; unicorn factory."
    },
    D2: {
      "1": "No legacy.",
      "2": "Short-term legacy.",
      "3": "Growing legacy.",
      "4": "Strong legacy.",
      "5": "Legendary; generational impact."
    },
    D3: {
      "1": "No societal impact.",
      "2": "Minor impact.",
      "3": "Noticeable impact.",
      "4": "Major impact.",
      "5": "Transformative societal impact."
    },
    D4: {
      "1": "No inspiration.",
      "2": "Occasionally inspiring.",
      "3": "Regularly inspiring.",
      "4": "Consistently inspiring.",
      "5": "Legendary inspiration source."
    },
    D5: {
      "1": "Local only.",
      "2": "Regional.",
      "3": "National.",
      "4": "International.",
      "5": "Global presence; legendary reach."
    },
    D6: {
      "1": "No industry disruption.",
      "2": "Minor disruption.",
      "3": "Some disruption.",
      "4": "Major disruption.",
      "5": "Industry-defining disruption."
    },
    D7: {
      "1": "No standards set.",
      "2": "Following standards.",
      "3": "Meeting standards.",
      "4": "Setting standards.",
      "5": "Defining the standards; legendary."
    },
    D8: {
      "1": "No ecosystem building.",
      "2": "Minimal ecosystem role.",
      "3": "Active ecosystem building.",
      "4": "Ecosystem orchestrator.",
      "5": "Legendary ecosystem architect."
    },
    D9: {
      "1": "No systemic change.",
      "2": "Minor change.",
      "3": "Some systemic change.",
      "4": "Major systemic change.",
      "5": "Permanent systemic change."
    }
  },
  L8: {
    D1: {
      "1": "Extractive model.",
      "2": "Break-even focus.",
      "3": "Sustainable practices.",
      "4": "Stewardship mindset.",
      "5": "Legendary stewardship."
    },
    D2: {
      "1": "Founders as product.",
      "2": "Transactional value.",
      "3": "Balanced value.",
      "4": "Founder-first value.",
      "5": "Ecosystem value creation."
    },
    D3: {
      "1": "No sustainability focus.",
      "2": "Basic sustainability.",
      "3": "Good sustainability practices.",
      "4": "Strong sustainability commitment.",
      "5": "Regenerative practices."
    },
    D4: {
      "1": "No social mission.",
      "2": "Token social focus.",
      "3": "Clear social mission.",
      "4": "Strong social impact.",
      "5": "Transformative social change."
    },
    D5: {
      "1": "Opaque governance.",
      "2": "Basic transparency.",
      "3": "Good governance.",
      "4": "Strong governance.",
      "5": "Legendary transparency."
    },
    D6: {
      "1": "Questionable ethics.",
      "2": "Compliance ethics.",
      "3": "Good ethics.",
      "4": "Strong ethics.",
      "5": "Legendary ethical standards."
    },
    D7: {
      "1": "Extractive community relations.",
      "2": "Transactional community.",
      "3": "Good community partnership.",
      "4": "Strong community integration.",
      "5": "Transformative community pillar."
    },
    D8: {
      "1": "Short-term thinking.",
      "2": "Annual planning.",
      "3": "5–10 year view.",
      "4": "Multi-decade planning.",
      "5": "Generational thinking."
    },
    D9: {
      "1": "Values ignored.",
      "2": "Values stated.",
      "3": "Values practiced.",
      "4": "Values enforced.",
      "5": "Values are the strategy."
    }
  }
};

let updateCount = 0;
let missingCount = 0;

for (const [levelId, dimensions] of Object.entries(allUpdates)) {
  for (const [dimId, grades] of Object.entries(dimensions)) {
    if (!answerKeys[levelId]) {
      console.log(`Missing level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions) {
      console.log(`Missing questions in level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId]) {
      console.log(`Missing dimension: ${levelId} ${dimId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders) {
      answerKeys[levelId].questions[dimId].stakeholders = {};
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER]) {
      answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER] = {
        question: "",
        grades: {}
      };
    }
    
    const stakeholderData = answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER];
    if (!stakeholderData.grades) {
      stakeholderData.grades = {};
    }
    
    for (const [grade, answer] of Object.entries(grades)) {
      stakeholderData.grades[grade] = answer;
    }
    updateCount++;
    
    console.log(`Updated ${levelId} ${dimId} (5 grades)`);
  }
}

fs.writeFileSync(answerKeysPath, JSON.stringify(answerKeys, null, 2), 'utf-8');

console.log(`\n✅ Updated ${updateCount} Enabler (Accelerator) entries with all 5 grades.`);
console.log(`⚠️ Missing entries: ${missingCount}`);
console.log(`Total individual grade updates: ${updateCount * 5}`);
console.log(`File saved to: ${answerKeysPath}`);
