const fs = require('fs');
const path = require('path');

const answerKeysPath = path.join(__dirname, '../client/src/lib/answerKeys.json');
const answerKeys = JSON.parse(fs.readFileSync(answerKeysPath, 'utf-8'));

const STAKEHOLDER = "Facilitator (Services)";

const allUpdates = {
  L0: {
    D1: {
      "1": "I have no safe space.",
      "2": "I create some safety.",
      "3": "I hold space for vulnerability.",
      "4": "I create deep psychological safety.",
      "5": "I am legendary for enabling breakthroughs."
    },
    D2: {
      "1": "I lecture and advise.",
      "2": "I mostly present.",
      "3": "I facilitate dialogue.",
      "4": "I enable co-creation.",
      "5": "I am invisible; the group leads itself."
    },
    D3: {
      "1": "I have no process.",
      "2": "I have a loose agenda.",
      "3": "I have a clear methodology.",
      "4": "I have a proven framework.",
      "5": "I am legendary for process design."
    },
    D4: {
      "1": "I have no resilience focus.",
      "2": "I mention resilience.",
      "3": "I build resilience exercises in.",
      "4": "I coach through setbacks.",
      "5": "I am legendary for normalizing setbacks."
    },
    D5: {
      "1": "I have no credentials.",
      "2": "I have basic training.",
      "3": "I have relevant certifications.",
      "4": "I have deep expertise.",
      "5": "I am legendary in my field."
    },
    D6: {
      "1": "I cannot read the room.",
      "2": "I miss some cues.",
      "3": "I read the room well.",
      "4": "I sense unspoken dynamics.",
      "5": "I am legendary for emotional intelligence."
    },
    D7: {
      "1": "I cannot adapt.",
      "2": "I struggle to flex.",
      "3": "I adapt to surprises.",
      "4": "I thrive in chaos.",
      "5": "I am legendary for emergent design."
    },
    D8: {
      "1": "I disappear after sessions.",
      "2": "I am available sometimes.",
      "3": "I am reliably accessible.",
      "4": "I am always responsive.",
      "5": "I am a lifelong resource."
    },
    D9: {
      "1": "I am extractive.",
      "2": "I am transactional.",
      "3": "I balance service and income.",
      "4": "I prioritize their success.",
      "5": "I am radically service-oriented."
    },
    EiR1: {
      "1": "I overestimate my value.",
      "2": "I sometimes misjudge my impact.",
      "3": "I have realistic self-assessment.",
      "4": "I seek feedback actively.",
      "5": "I have deep, earned confidence."
    },
    EiR2: {
      "1": "I ignore power dynamics.",
      "2": "I miss some dynamics.",
      "3": "I am aware of dynamics.",
      "4": "I navigate dynamics expertly.",
      "5": "I am legendary for managing politics."
    },
    EiR3: {
      "1": "I am exploitative.",
      "2": "I am primarily self-interested.",
      "3": "I balance interests.",
      "4": "I prioritize their interests.",
      "5": "I am purely service-driven."
    },
    EiR4: {
      "1": "I am out of date.",
      "2": "I am slightly dated.",
      "3": "I am current.",
      "4": "I am ahead of the curve.",
      "5": "I define the curve."
    },
    EiR5: {
      "1": "I am burning out.",
      "2": "I am fatigued.",
      "3": "I am managing energy.",
      "4": "I am thriving.",
      "5": "I am regenerative; I am energized by the work."
    },
    EiR6: {
      "1": "My methods do not scale.",
      "2": "I struggle to scale.",
      "3": "I can train others.",
      "4": "I have a scalable model.",
      "5": "I am legendary for scaling impact."
    },
    EiR7: {
      "1": "I am a one-trick pony.",
      "2": "I have limited range.",
      "3": "I have a good range.",
      "4": "I have a strong range.",
      "5": "I am legendary for versatility."
    },
    EiR8: {
      "1": "I am totally dependent on one client.",
      "2": "I have a few clients.",
      "3": "I have a diversified portfolio.",
      "4": "I have strong, recurring clients.",
      "5": "I have legendary client loyalty."
    },
    EiR9: {
      "1": "I am in it for ego.",
      "2": "I am in it for money.",
      "3": "I balance purpose and income.",
      "4": "I am purpose-driven.",
      "5": "I am legendary for service."
    }
  },
  L1: {
    D1: {
      "1": "I do not help validation.",
      "2": "I suggest basic surveys.",
      "3": "I facilitate customer interviews.",
      "4": "I run validation sprints.",
      "5": "I am legendary for validation facilitation."
    },
    D2: {
      "1": "I cannot facilitate groups.",
      "2": "I run basic workshops.",
      "3": "I facilitate well.",
      "4": "I facilitate complex groups.",
      "5": "I am legendary for group dynamics."
    },
    D3: {
      "1": "I have no research skills.",
      "2": "I can find basic info.",
      "3": "I have good research skills.",
      "4": "I have deep research skills.",
      "5": "I am legendary for insights."
    },
    D4: {
      "1": "I ignore data.",
      "2": "I am data-aware.",
      "3": "I am data-informed.",
      "4": "I am data-driven.",
      "5": "I am legendary for data synthesis."
    },
    D5: {
      "1": "I am unavailable.",
      "2": "I have limited availability.",
      "3": "I have good availability.",
      "4": "I have strong availability.",
      "5": "I am always available when needed."
    },
    D6: {
      "1": "I have no niche.",
      "2": "I have a vague niche.",
      "3": "I have a clear niche.",
      "4": "I have a strong niche.",
      "5": "I am the category leader."
    },
    D7: {
      "1": "I give advice.",
      "2": "I mostly advise.",
      "3": "I facilitate discovery.",
      "4": "I enable deep learning.",
      "5": "I am legendary for Socratic facilitation."
    },
    D8: {
      "1": "I blame the client.",
      "2": "I avoid difficult conversations.",
      "3": "I address challenges.",
      "4": "I navigate conflict well.",
      "5": "I am legendary for tough conversations."
    },
    D9: {
      "1": "I have no tools.",
      "2": "I have basic tools.",
      "3": "I have a good toolkit.",
      "4": "I have a strong toolkit.",
      "5": "I have a legendary toolkit."
    }
  },
  L2: {
    D1: {
      "1": "I cannot support builds.",
      "2": "I observe builds.",
      "3": "I facilitate sprint planning.",
      "4": "I run design sprints.",
      "5": "I am legendary for build facilitation."
    },
    D2: {
      "1": "I have no prototyping skills.",
      "2": "I can sketch ideas.",
      "3": "I facilitate low-fidelity prototyping.",
      "4": "I run high-fidelity prototyping.",
      "5": "I am legendary for rapid prototyping."
    },
    D3: {
      "1": "I have no design skills.",
      "2": "I give design opinions.",
      "3": "I facilitate design thinking.",
      "4": "I run design sprints.",
      "5": "I am legendary for design facilitation."
    },
    D4: {
      "1": "I ignore users.",
      "2": "I talk to users occasionally.",
      "3": "I facilitate user interviews.",
      "4": "I run user co-creation.",
      "5": "I am legendary for user-centered design."
    },
    D5: {
      "1": "I am inefficient.",
      "2": "I am somewhat efficient.",
      "3": "I am efficient.",
      "4": "I am highly efficient.",
      "5": "I am legendary for lean processes."
    },
    D6: {
      "1": "I have no frameworks.",
      "2": "I use generic frameworks.",
      "3": "I have tailored frameworks.",
      "4": "I have strong frameworks.",
      "5": "I have legendary, proprietary frameworks."
    },
    D7: {
      "1": "I have no technical understanding.",
      "2": "I know buzzwords.",
      "3": "I understand tech basics.",
      "4": "I have strong tech literacy.",
      "5": "I am legendary for bridging tech and business."
    },
    D8: {
      "1": "I ignore team dynamics.",
      "2": "I observe team dynamics.",
      "3": "I facilitate team alignment.",
      "4": "I build high-performing teams.",
      "5": "I am legendary for team transformation."
    },
    D9: {
      "1": "I am rigid.",
      "2": "I am somewhat flexible.",
      "3": "I am flexible.",
      "4": "I am highly adaptable.",
      "5": "I am legendary for emergent facilitation."
    }
  },
  L3: {
    D1: {
      "1": "I cannot help with traction.",
      "2": "I give generic advice.",
      "3": "I facilitate go-to-market planning.",
      "4": "I run launch workshops.",
      "5": "I am legendary for launch facilitation."
    },
    D2: {
      "1": "I have no sales skills.",
      "2": "I have basic sales knowledge.",
      "3": "I facilitate sales training.",
      "4": "I run sales enablement.",
      "5": "I am legendary for sales transformation."
    },
    D3: {
      "1": "I have no marketing skills.",
      "2": "I have basic marketing knowledge.",
      "3": "I facilitate marketing planning.",
      "4": "I run marketing workshops.",
      "5": "I am legendary for marketing strategy."
    },
    D4: {
      "1": "I have no customer success skills.",
      "2": "I have basic knowledge.",
      "3": "I facilitate customer journey mapping.",
      "4": "I run customer experience workshops.",
      "5": "I am legendary for customer transformation."
    },
    D5: {
      "1": "I have no metrics focus.",
      "2": "I track basic metrics.",
      "3": "I facilitate KPI workshops.",
      "4": "I run OKR facilitation.",
      "5": "I am legendary for metrics-driven facilitation."
    },
    D6: {
      "1": "I have no positioning skills.",
      "2": "I give generic advice.",
      "3": "I facilitate positioning workshops.",
      "4": "I run brand strategy sessions.",
      "5": "I am legendary for positioning transformation."
    },
    D7: {
      "1": "I have no momentum skills.",
      "2": "I observe momentum.",
      "3": "I help build momentum.",
      "4": "I accelerate momentum.",
      "5": "I am legendary for creating breakthroughs."
    },
    D8: {
      "1": "I have no network.",
      "2": "I have a small network.",
      "3": "I make relevant introductions.",
      "4": "I open doors.",
      "5": "I am legendary for connections."
    },
    D9: {
      "1": "I am generic.",
      "2": "I am somewhat differentiated.",
      "3": "I am clearly differentiated.",
      "4": "I am strongly differentiated.",
      "5": "I am legendary; I am the only one."
    }
  },
  L4: {
    D1: {
      "1": "I cannot help scaling.",
      "2": "I give generic scaling advice.",
      "3": "I facilitate scaling workshops.",
      "4": "I run scale-up programs.",
      "5": "I am legendary for scaling facilitation."
    },
    D2: {
      "1": "I have no organizational design skills.",
      "2": "I have basic knowledge.",
      "3": "I facilitate org design.",
      "4": "I run org transformation.",
      "5": "I am legendary for organizational design."
    },
    D3: {
      "1": "I have no process design skills.",
      "2": "I have basic knowledge.",
      "3": "I facilitate process workshops.",
      "4": "I run operational excellence programs.",
      "5": "I am legendary for process transformation."
    },
    D4: {
      "1": "I have no systems thinking.",
      "2": "I am aware of systems.",
      "3": "I facilitate systems mapping.",
      "4": "I run systems transformation.",
      "5": "I am legendary for systems thinking."
    },
    D5: {
      "1": "I have no change management skills.",
      "2": "I have basic knowledge.",
      "3": "I facilitate change planning.",
      "4": "I run change programs.",
      "5": "I am legendary for change facilitation."
    },
    D6: {
      "1": "I have no stakeholder management skills.",
      "2": "I have basic skills.",
      "3": "I facilitate stakeholder mapping.",
      "4": "I run stakeholder alignment.",
      "5": "I am legendary for stakeholder management."
    },
    D7: {
      "1": "I have no strategic planning skills.",
      "2": "I have basic knowledge.",
      "3": "I facilitate strategy workshops.",
      "4": "I run strategic planning.",
      "5": "I am legendary for strategic planning."
    },
    D8: {
      "1": "I have no crisis management skills.",
      "2": "I have basic knowledge.",
      "3": "I facilitate crisis planning.",
      "4": "I run crisis response.",
      "5": "I am legendary for crisis management."
    },
    D9: {
      "1": "I have no energy management skills.",
      "2": "I struggle with energy.",
      "3": "I manage my energy.",
      "4": "I have high energy.",
      "5": "I am legendary for sustained energy."
    }
  },
  L5: {
    D1: {
      "1": "I do not see process.",
      "2": "I draw flowcharts.",
      "3": "I facilitate value stream maps.",
      "4": "I eliminate waste (Lean).",
      "5": "I achieve flow."
    },
    D2: {
      "1": "I cut blindly.",
      "2": "I ask for budget cuts.",
      "3": "I workshop efficiencies.",
      "4": "I optimize unit economics.",
      "5": "I turn cost into value."
    },
    D3: {
      "1": "I fear robots.",
      "2": "I suggest tools.",
      "3": "I map automation opportunities.",
      "4": "I facilitate digital transformation.",
      "5": "I design autonomous systems."
    },
    D4: {
      "1": "Decisions drag on.",
      "2": "We vote on everything.",
      "3": "I use decision frameworks.",
      "4": "I enable rapid consensus.",
      "5": "I institutionalize speed."
    },
    D5: {
      "1": "Meetings are toxic.",
      "2": "Meetings are average.",
      "3": "I run great meetings.",
      "4": "I teach meeting mastery.",
      "5": "I eliminate useless meetings."
    },
    D6: {
      "1": "Opinions rule.",
      "2": "Data is an afterthought.",
      "3": "We look at dashboards.",
      "4": "Data drives the room.",
      "5": "Truth wins over ego."
    },
    D7: {
      "1": "Everything is P1.",
      "2": "We fight over priorities.",
      "3": "I use RICE/WSJF.",
      "4": "I align resources to value.",
      "5": "We do less, better."
    },
    D8: {
      "1": "Silos act alone.",
      "2": "I introduce silos.",
      "3": "I run cross-functional workshops.",
      "4": "I build connective tissue.",
      "5": "The org is a network."
    },
    D9: {
      "1": "Revenue at all costs.",
      "2": "Profit is for finance.",
      "3": "Everyone knows margins.",
      "4": "Profit is a design constraint.",
      "5": "Profit is a discipline."
    }
  },
  L6: {
    D1: {
      "1": "No vision.",
      "2": "Vague statements.",
      "3": "Clear vision statement.",
      "4": "Compelling strategic intent.",
      "5": "A massive transformative purpose."
    },
    D2: {
      "1": "I block them.",
      "2": "I tolerate them.",
      "3": "I run hackathons.",
      "4": "I run venture builders.",
      "5": "I unleash the organization."
    },
    D3: {
      "1": "Failure is punished.",
      "2": "Risk is avoided.",
      "3": "Calculated risk is okay.",
      "4": "Risk is managed portfolio.",
      "5": "Bold bets are celebrated."
    },
    D4: {
      "1": "I do it for them.",
      "2": "I train occasionally.",
      "3": "I transfer skills.",
      "4": "I build academies.",
      "5": "I create learning organisms."
    },
    D5: {
      "1": "Internal focus only.",
      "2": "Vendor management.",
      "3": "Open innovation events.",
      "4": "Ecosystem orchestration.",
      "5": "Boundaryless innovation."
    },
    D6: {
      "1": "Fear rules.",
      "2": "Silence is safe.",
      "3": "Ideas are welcome.",
      "4": "Dissent is encouraged.",
      "5": "Radical candor is the norm."
    },
    D7: {
      "1": "Ad hoc funding.",
      "2": "Annual budget fight.",
      "3": "Metered funding.",
      "4": "Venture board logic.",
      "5": "Portfolio thinking."
    },
    D8: {
      "1": "Core kills explore.",
      "2": "Explore is a hobby.",
      "3": "Balanced portfolio.",
      "4": "Synergistic engines.",
      "5": "Seamless integration."
    },
    D9: {
      "1": "I am invisible.",
      "2": "I present slides.",
      "3": "I advise strategy.",
      "4": "I shape the agenda.",
      "5": "I am the trusted guide."
    }
  },
  L7: {
    D1: {
      "1": "No influence.",
      "2": "Attendee.",
      "3": "Panelist.",
      "4": "Convener.",
      "5": "Industry shaper."
    },
    D2: {
      "1": "I stay away.",
      "2": "I handle logistics.",
      "3": "I facilitate culture merge.",
      "4": "I design the new entity.",
      "5": "I create synergy instantly."
    },
    D3: {
      "1": "Follower.",
      "2": "Complainer.",
      "3": "Adopter.",
      "4": "Contributor.",
      "5": "Author of standards."
    },
    D4: {
      "1": "No legacy.",
      "2": "Stories told.",
      "3": "Case studies written.",
      "4": "Institutional memory.",
      "5": "History is written by us."
    },
    D5: {
      "1": "No followers.",
      "2": "Some peers.",
      "3": "Respected pro.",
      "4": "Mentor to many.",
      "5": "Guru of the field."
    },
    D6: {
      "1": "I use the book.",
      "2": "I tweak methods.",
      "3": "I mix methods.",
      "4": "I create new frameworks.",
      "5": "My methods are the standard."
    },
    D7: {
      "1": "Silent.",
      "2": "Blogger.",
      "3": "Speaker.",
      "4": "Author.",
      "5": "Icon."
    },
    D8: {
      "1": "Small rolodex.",
      "2": "Local network.",
      "3": "Strong connections.",
      "4": "Global reach.",
      "5": "The network is the platform."
    },
    D9: {
      "1": "Invisible.",
      "2": "Activity-based.",
      "3": "Outcome-based.",
      "4": "Transformational.",
      "5": "Historic."
    }
  },
  L8: {
    D1: {
      "1": "I ignore ethics.",
      "2": "I follow rules.",
      "3": "I discuss ethics.",
      "4": "I enforce ethics.",
      "5": "I am the moral compass."
    },
    D2: {
      "1": "I ignore climate.",
      "2": "I reduce waste.",
      "3": "I run sustainable events.",
      "4": "I drive circularity.",
      "5": "I facilitate regeneration."
    },
    D3: {
      "1": "I am exclusive.",
      "2": "I am open.",
      "3": "I am inclusive.",
      "4": "I am equitable.",
      "5": "I decolonize the space."
    },
    D4: {
      "1": "The meeting.",
      "2": "The project.",
      "3": "The year.",
      "4": "The decade.",
      "5": "The generation."
    },
    D5: {
      "1": "My client only.",
      "2": "The participants.",
      "3": "The organization.",
      "4": "The community.",
      "5": "The ecosystem."
    },
    D6: {
      "1": "Information.",
      "2": "Knowledge.",
      "3": "Experience.",
      "4": "Insight.",
      "5": "Wisdom."
    },
    D7: {
      "1": "I hold power.",
      "2": "I delegate tasks.",
      "3": "I share responsibility.",
      "4": "I distribute power.",
      "5": "I empower the system."
    },
    D8: {
      "1": "I am the bottleneck.",
      "2": "I have a backup.",
      "3": "I document everything.",
      "4": "I train successors.",
      "5": "The work survives me."
    },
    D9: {
      "1": "For money.",
      "2": "For ego.",
      "3": "For results.",
      "4": "For service.",
      "5": "For humanity."
    },
    EiR1: {
      "1": "I dictate.",
      "2": "I steer too much.",
      "3": "I guide.",
      "4": "I serve.",
      "5": "I am empty."
    },
    EiR2: {
      "1": "Rigid adherence.",
      "2": "Defensive of method.",
      "3": "Flexible.",
      "4": "Method agnostic.",
      "5": "Beyond method."
    },
    EiR3: {
      "1": "Collapsing.",
      "2": "Exhausted.",
      "3": "Balanced.",
      "4": "Regenerative.",
      "5": "Energized by the work."
    },
    EiR4: {
      "1": "Sold out.",
      "2": "Biased by pay.",
      "3": "Neutral.",
      "4": "Integrity.",
      "5": "Uncorruptible."
    },
    EiR5: {
      "1": "Dinosaur.",
      "2": "Fading.",
      "3": "Current.",
      "4": "Timeless.",
      "5": "Ahead of time."
    },
    EiR6: {
      "1": "Parasitic.",
      "2": "Transactional.",
      "3": "Balanced exchange.",
      "4": "Generous.",
      "5": "Philanthropic."
    },
    EiR7: {
      "1": "Tools of the oppressor.",
      "2": "Elite-focused.",
      "3": "Accessible.",
      "4": "Democratizing.",
      "5": "Liberating."
    },
    EiR8: {
      "1": "Quick wins only.",
      "2": "Short-sighted.",
      "3": "Sustainable wins.",
      "4": "Future-proof.",
      "5": "Seventh-generation thinking."
    },
    EiR9: {
      "1": "Look at me.",
      "2": "Look at us.",
      "3": "Look at the work.",
      "4": "Look at the impact.",
      "5": "Look at the future."
    }
  }
};

let updateCount = 0;
let missingCount = 0;

for (const [levelId, dimensions] of Object.entries(allUpdates)) {
  for (const [dimId, grades] of Object.entries(dimensions)) {
    if (!answerKeys[levelId]) {
      console.log(`Missing level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions) {
      console.log(`Missing questions in level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId]) {
      console.log(`Missing dimension: ${levelId} ${dimId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders) {
      answerKeys[levelId].questions[dimId].stakeholders = {};
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER]) {
      answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER] = {
        question: "",
        grades: {}
      };
    }
    
    const stakeholderData = answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER];
    if (!stakeholderData.grades) {
      stakeholderData.grades = {};
    }
    
    for (const [grade, answer] of Object.entries(grades)) {
      stakeholderData.grades[grade] = answer;
    }
    updateCount++;
    
    console.log(`Updated ${levelId} ${dimId} (5 grades)`);
  }
}

fs.writeFileSync(answerKeysPath, JSON.stringify(answerKeys, null, 2), 'utf-8');

console.log(`\n✅ Updated ${updateCount} Facilitator (Services) entries with all 5 grades.`);
console.log(`⚠️ Missing entries: ${missingCount}`);
console.log(`Total individual grade updates: ${updateCount * 5}`);
console.log(`File saved to: ${answerKeysPath}`);
