const fs = require('fs');
const path = require('path');

const answerKeysPath = path.join(__dirname, '../client/src/lib/answerKeys.json');
const answerKeys = JSON.parse(fs.readFileSync(answerKeysPath, 'utf-8'));

const STAKEHOLDER = "Professional (Talent)";

const allUpdates = {
  L0: {
    D1: {
      "1": "I am fully salary-dependent; I have no risk appetite.",
      "2": "I have a secure job but am curious.",
      "3": "I have some savings; I am risk-aware.",
      "4": "I have a strong financial buffer.",
      "5": "I am financially independent; I can take any risk."
    },
    D2: {
      "1": "I do not know why I want this; no clarity.",
      "2": "I think it sounds exciting.",
      "3": "I have clear reasons for joining startups.",
      "4": "I have deep self-awareness of my startup fit.",
      "5": "I have crystal-clear purpose alignment."
    },
    D3: {
      "1": "I assume startups are easy.",
      "2": "I have read about startup life.",
      "3": "I have realistic expectations from research.",
      "4": "I have experienced startup chaos firsthand.",
      "5": "I am a startup veteran; I know the reality."
    },
    D4: {
      "1": "I have no skills relevant to startups.",
      "2": "I have corporate skills that may transfer.",
      "3": "I have clear, relevant skills.",
      "4": "I have rare, high-demand skills.",
      "5": "I am a unicorn; my skills are legendary."
    },
    D5: {
      "1": "I will sacrifice nothing; I want work-life balance.",
      "2": "I am willing to work hard sometimes.",
      "3": "I am prepared for startup intensity.",
      "4": "I thrive on intensity; I am all-in.",
      "5": "I live for the mission; sacrifice is a joy."
    },
    D6: {
      "1": "I cannot handle stress; I break.",
      "2": "I handle stress poorly.",
      "3": "I manage stress reasonably well.",
      "4": "I am stress-resistant; I thrive in chaos.",
      "5": "I am antifragile; chaos makes me stronger."
    },
    D7: {
      "1": "I need constant direction; I am dependent.",
      "2": "I prefer structure but can adapt.",
      "3": "I am self-directed with guidance.",
      "4": "I am highly autonomous.",
      "5": "I create structure from chaos; I am a leader."
    },
    D8: {
      "1": "I do not know about regulations.",
      "2": "I am vaguely aware of regulations.",
      "3": "I understand key regulatory issues.",
      "4": "I am well-versed in startup regulations.",
      "5": "I am an expert in navigating regulations."
    },
    D9: {
      "1": "I cannot learn new things; fixed mindset.",
      "2": "I learn slowly; I prefer expertise.",
      "3": "I am willing to learn and grow.",
      "4": "I am a fast learner; I am adaptable.",
      "5": "I am a learning machine; I thrive on growth."
    },
    EiR1: {
      "1": "I am naively confident; I know little.",
      "2": "I have superficial confidence.",
      "3": "I have balanced confidence and awareness.",
      "4": "I have realistic confidence; I am grounded.",
      "5": "I have earned confidence; I know my limits."
    },
    EiR2: {
      "1": "I focus on the outcome (delusion).",
      "2": "I focus on the experience (false).",
      "3": "I focus on the journey (unverified).",
      "4": "I focus on the process; tested.",
      "5": "I focus on purpose; proven."
    },
    EiR3: {
      "1": "I am desperate for any job.",
      "2": "I am actively looking.",
      "3": "I am exploring opportunities.",
      "4": "I am selectively open.",
      "5": "I am in demand; I am choosing carefully."
    },
    EiR4: {
      "1": "My skills are obsolete.",
      "2": "My skills are becoming dated.",
      "3": "My skills are current.",
      "4": "My skills are future-proof.",
      "5": "My skills are cutting-edge; I define trends."
    },
    EiR5: {
      "1": "I am burning out already.",
      "2": "I am showing fatigue signs.",
      "3": "I am managing well.",
      "4": "I am thriving.",
      "5": "I am energized; I am at peak performance."
    },
    EiR6: {
      "1": "I will give up at the first sign of trouble.",
      "2": "I may give up if it gets hard.",
      "3": "I will persist through some challenges.",
      "4": "I will persist through most challenges.",
      "5": "I will never give up; I am relentless."
    },
    EiR7: {
      "1": "I have no backup plan.",
      "2": "I have a vague backup plan.",
      "3": "I have a clear backup plan.",
      "4": "I have multiple options.",
      "5": "I am financially independent; I have no risk."
    },
    EiR8: {
      "1": "My personal life is a mess.",
      "2": "My personal life is strained.",
      "3": "My personal life is stable.",
      "4": "My personal life is supportive.",
      "5": "My personal life is thriving; I have full support."
    },
    EiR9: {
      "1": "I have no network.",
      "2": "I have a small network.",
      "3": "I have a good network.",
      "4": "I have a strong network.",
      "5": "I have a legendary network; doors open for me."
    }
  },
  L1: {
    D1: {
      "1": "I have no market value in startups.",
      "2": "I have limited market value.",
      "3": "I have clear market value.",
      "4": "I have high market value.",
      "5": "I am in legendary demand."
    },
    D2: {
      "1": "I have not researched the market.",
      "2": "I have done basic research.",
      "3": "I have done thorough research.",
      "4": "I have deep market knowledge.",
      "5": "I am an expert in startup markets."
    },
    D3: {
      "1": "I have no feedback.",
      "2": "I have limited feedback.",
      "3": "I have good feedback.",
      "4": "I have strong feedback.",
      "5": "I have legendary feedback; I am sought after."
    },
    D4: {
      "1": "I have no interest from startups.",
      "2": "I have some interest.",
      "3": "I have good interest.",
      "4": "I have strong interest.",
      "5": "I have legendary interest; I am in demand."
    },
    D5: {
      "1": "I am bleeding savings.",
      "2": "I have limited runway.",
      "3": "I have good runway.",
      "4": "I have strong runway.",
      "5": "I have legendary runway; I am financially free."
    },
    D6: {
      "1": "I have no unique skills.",
      "2": "I have some unique skills.",
      "3": "I have clear unique skills.",
      "4": "I have strong unique skills.",
      "5": "I have legendary skills; I am irreplaceable."
    },
    D7: {
      "1": "I have no development path.",
      "2": "I have a vague development path.",
      "3": "I have a clear development path.",
      "4": "I have a strong development path.",
      "5": "I have a legendary development path."
    },
    D8: {
      "1": "I blame others for failures.",
      "2": "I struggle with failure.",
      "3": "I learn from failures.",
      "4": "I embrace failures.",
      "5": "I am legendary at learning from failure."
    },
    D9: {
      "1": "I have no clear value proposition.",
      "2": "I have a vague value proposition.",
      "3": "I have a clear value proposition.",
      "4": "I have a strong value proposition.",
      "5": "I have a legendary value proposition."
    },
    EiR1: {
      "1": "I am unaware of my value.",
      "2": "I undervalue myself.",
      "3": "I know my value.",
      "4": "I maximize my value.",
      "5": "I am legendary; I define value."
    },
    EiR2: {
      "1": "I have no risk identification.",
      "2": "I have limited risk awareness.",
      "3": "I identify some risks.",
      "4": "I identify most risks.",
      "5": "I identify all risks; I am expert."
    },
    EiR3: {
      "1": "I have toxic references.",
      "2": "I have weak references.",
      "3": "I have good references.",
      "4": "I have strong references.",
      "5": "I have legendary references."
    },
    EiR4: {
      "1": "I am being disrupted.",
      "2": "I am at risk of disruption.",
      "3": "I am adapting to changes.",
      "4": "I am ahead of changes.",
      "5": "I am driving disruption."
    },
    EiR5: {
      "1": "I am under severe financial pressure.",
      "2": "I am under moderate pressure.",
      "3": "I am stable.",
      "4": "I am comfortable.",
      "5": "I am financially free."
    },
    EiR6: {
      "1": "I am unaware of regulations.",
      "2": "I have limited awareness.",
      "3": "I am aware of key regulations.",
      "4": "I am well-versed in regulations.",
      "5": "I am an expert in regulations."
    },
    EiR7: {
      "1": "My expectations are unrealistic.",
      "2": "My expectations are high.",
      "3": "My expectations are balanced.",
      "4": "My expectations are realistic.",
      "5": "My expectations are perfectly calibrated."
    },
    EiR8: {
      "1": "I am burned out.",
      "2": "I am fatigued.",
      "3": "I am managing.",
      "4": "I am thriving.",
      "5": "I am at peak performance."
    },
    EiR9: {
      "1": "I have no validation; pure, organic metrics only.",
      "2": "I have limited validation.",
      "3": "I have good validation.",
      "4": "I have strong validation.",
      "5": "I have exceptional validation."
    }
  },
  L2: {
    D1: {
      "1": "I cannot build anything.",
      "2": "I can build basic things.",
      "3": "I can build well.",
      "4": "I can build excellently.",
      "5": "I am a legendary builder."
    },
    D2: {
      "1": "I have no technical skills.",
      "2": "I have limited technical skills.",
      "3": "I have good technical skills.",
      "4": "I have strong technical skills.",
      "5": "I have legendary technical skills."
    },
    D3: {
      "1": "I have no framework.",
      "2": "I have a basic framework.",
      "3": "I have a good framework.",
      "4": "I have a strong framework.",
      "5": "I have a legendary framework."
    },
    D4: {
      "1": "I cannot co-design.",
      "2": "I can co-design basics.",
      "3": "I can co-design well.",
      "4": "I can co-design excellently.",
      "5": "I am a legendary co-designer."
    },
    D5: {
      "1": "I am wasteful.",
      "2": "I am somewhat efficient.",
      "3": "I am efficient.",
      "4": "I am highly efficient.",
      "5": "I am exceptionally efficient."
    },
    D6: {
      "1": "My approach is generic.",
      "2": "My approach is basic.",
      "3": "My approach is clear.",
      "4": "My approach is strong.",
      "5": "My approach is legendary."
    },
    D7: {
      "1": "I have no market education.",
      "2": "I have basic market education.",
      "3": "I have good market education.",
      "4": "I have strong market education.",
      "5": "I have exceptional market education."
    },
    D8: {
      "1": "I offer no team support.",
      "2": "I offer basic team support.",
      "3": "I offer good team support.",
      "4": "I offer strong team support.",
      "5": "I offer legendary team support."
    },
    D9: {
      "1": "I am rigid.",
      "2": "I am somewhat flexible.",
      "3": "I am flexible.",
      "4": "I am highly flexible.",
      "5": "I am exceptionally adaptive."
    }
  },
  L3: {
    D1: {
      "1": "I drive no revenue.",
      "2": "I drive minimal revenue.",
      "3": "I drive some revenue.",
      "4": "I drive good revenue.",
      "5": "I am a legendary revenue driver."
    },
    D2: {
      "1": "I cannot acquire customers.",
      "2": "I have limited acquisition.",
      "3": "I have good acquisition.",
      "4": "I have strong acquisition.",
      "5": "I have legendary acquisition."
    },
    D3: {
      "1": "I am disengaged.",
      "2": "I am somewhat engaged.",
      "3": "I am engaged.",
      "4": "I am highly engaged.",
      "5": "I am a legendary evangelist."
    },
    D4: {
      "1": "I cannot drive organic growth.",
      "2": "I have limited organic growth.",
      "3": "I have good organic growth.",
      "4": "I have strong organic growth.",
      "5": "I have referral-driven growth mastery."
    },
    D5: {
      "1": "I am customer-unaware.",
      "2": "I am customer-confused.",
      "3": "I am customer-informed.",
      "4": "I am customer-centric.",
      "5": "I am customer-obsessed."
    },
    D6: {
      "1": "I am generic.",
      "2": "I am somewhat differentiated.",
      "3": "I am differentiated.",
      "4": "I am strongly differentiated.",
      "5": "I am legendary; I create categories."
    },
    D7: {
      "1": "I have no momentum.",
      "2": "I have limited momentum.",
      "3": "I have good momentum.",
      "4": "I have strong momentum.",
      "5": "I am unstoppable."
    },
    D8: {
      "1": "I am easily replaced.",
      "2": "I am somewhat replaceable.",
      "3": "I am hard to replace.",
      "4": "I am very hard to replace.",
      "5": "I am irreplaceable."
    },
    D9: {
      "1": "I am a follower.",
      "2": "I am emerging.",
      "3": "I am leading.",
      "4": "I am strongly leading.",
      "5": "I am an industry icon."
    }
  },
  L4: {
    D1: {
      "1": "I drive no revenue growth.",
      "2": "I drive minimal growth.",
      "3": "I contribute some growth.",
      "4": "I contribute good growth.",
      "5": "I am a primary growth driver."
    },
    D2: {
      "1": "I cannot acquire at scale.",
      "2": "I have limited scaling.",
      "3": "I have moderate scaling.",
      "4": "I have strong scaling.",
      "5": "I have exceptional scaling."
    },
    D3: {
      "1": "I have no process.",
      "2": "I have some process.",
      "3": "I have a clear process.",
      "4": "I have a refined process.",
      "5": "I build legendary systems."
    },
    D4: {
      "1": "I cannot expand roles.",
      "2": "I have limited expansion.",
      "3": "I am expanding roles.",
      "4": "I have strong expansion.",
      "5": "I have legend expansion."
    },
    D5: {
      "1": "I break economics at scale.",
      "2": "I see pressure at scale.",
      "3": "I am good at scale.",
      "4": "I improve at scale.",
      "5": "I have exceptional scale."
    },
    D6: {
      "1": "I have eroding skills.",
      "2": "I have weak differentiation.",
      "3": "I have growing skills.",
      "4": "I have a strong edge.",
      "5": "I am irreplaceable."
    },
    D7: {
      "1": "I have no position.",
      "2": "I have an emerging position.",
      "3": "I have a clear position.",
      "4": "I have a strong position.",
      "5": "I have a legend position."
    },
    D8: {
      "1": "I am lost in the culture.",
      "2": "I strain the culture.",
      "3": "I support the culture.",
      "4": "I strengthen the culture.",
      "5": "I define the culture."
    },
    D9: {
      "1": "I have no bench.",
      "2": "I have a thin bench.",
      "3": "I have a growing bench.",
      "4": "I have a strong bench.",
      "5": "I have a legend bench."
    }
  },
  L5: {
    D1: {
      "1": "I create losses with every action.",
      "2": "I focus on growth only.",
      "3": "I balance growth/profit.",
      "4": "I am profit-focused.",
      "5": "I am profit obsessive."
    },
    D2: {
      "1": "I run inefficient chaos.",
      "2": "I have limited efficiency.",
      "3": "I have good efficiency.",
      "4": "I have high efficiency.",
      "5": "I have operational excellence."
    },
    D3: {
      "1": "I am losing per person.",
      "2": "I have low LTV.",
      "3": "I have good LTV.",
      "4": "I have high LTV.",
      "5": "I have exceptional LTV."
    },
    D4: {
      "1": "I cannot afford costs.",
      "2": "I have high costs.",
      "3": "I have reasonable costs.",
      "4": "I have low costs.",
      "5": "I have exceptional efficiency."
    },
    D5: {
      "1": "I have high turnover.",
      "2": "I have moderate turnover.",
      "3": "I have low turnover.",
      "4": "I have very low turnover.",
      "5": "I have near-zero turnover."
    },
    D6: {
      "1": "I am cash-bleeding.",
      "2": "I am cash-tight.",
      "3": "I am cash-healthy.",
      "4": "I have strong cash position.",
      "5": "I have cash abundance."
    },
    D7: {
      "1": "I have wasteful finances.",
      "2": "I have some efficiency.",
      "3": "I have good optimization.",
      "4": "I am well-optimized.",
      "5": "I have legend efficiency."
    },
    D8: {
      "1": "I have wasteful productivity.",
      "2": "I have inefficient use.",
      "3": "I have good efficiency.",
      "4": "I have excellent efficiency.",
      "5": "I have exceptional efficiency."
    },
    D9: {
      "1": "I have wasteful spending.",
      "2": "I have limited reinvestment.",
      "3": "I have good reinvestment.",
      "4": "I have strong reinvestment.",
      "5": "I have exceptional reinvestment."
    }
  },
  L6: {
    D1: {
      "1": "I have no leadership potential.",
      "2": "I have limited potential.",
      "3": "I have clear potential.",
      "4": "I have strong potential.",
      "5": "I have exceptional potential."
    },
    D2: {
      "1": "I cannot develop leaders.",
      "2": "I have limited development.",
      "3": "I have growing development.",
      "4": "I have strong development.",
      "5": "I have legend development."
    },
    D3: {
      "1": "I am reactive.",
      "2": "I have weak strategy.",
      "3": "I have good strategy.",
      "4": "I have strong strategy.",
      "5": "I am visionary strategy."
    },
    D4: {
      "1": "I have no innovation.",
      "2": "I have limited innovation.",
      "3": "I have some innovation.",
      "4": "I have strong innovation.",
      "5": "I have legendary innovation."
    },
    D5: {
      "1": "I cannot scale teams.",
      "2": "I struggle to scale.",
      "3": "I am scaling OK.",
      "4": "I scale smoothly.",
      "5": "I have legendary scaling."
    },
    D6: {
      "1": "I create toxic culture.",
      "2": "I create poor culture.",
      "3": "I create good culture.",
      "4": "I create strong culture.",
      "5": "I create legendary culture."
    },
    D7: {
      "1": "I cannot attract talent.",
      "2": "I have limited attraction.",
      "3": "I have good attraction.",
      "4": "I have strong attraction.",
      "5": "I have legendary attraction."
    },
    D8: {
      "1": "I am not mission-driven.",
      "2": "I am vaguely mission-driven.",
      "3": "I am clear mission-driven.",
      "4": "I am strong mission-driven.",
      "5": "I am legendary mission-driven."
    },
    D9: {
      "1": "I have no influence.",
      "2": "I have emerging influence.",
      "3": "I have good influence.",
      "4": "I have strong influence.",
      "5": "I have legendary influence."
    }
  },
  L7: {
    D1: {
      "1": "I make no contribution.",
      "2": "I have limited contribution.",
      "3": "I have some contribution.",
      "4": "I have strong contribution.",
      "5": "I am an owner of the unicorn."
    },
    D2: {
      "1": "I have no legacy.",
      "2": "I have minimal legacy.",
      "3": "I have clear legacy.",
      "4": "I have strong legacy.",
      "5": "I have legendary legacy."
    },
    D3: {
      "1": "I have no impact.",
      "2": "I have minimal impact.",
      "3": "I have clear impact.",
      "4": "I have strong impact.",
      "5": "I have transformative impact."
    },
    D4: {
      "1": "I cannot inspire.",
      "2": "I have limited inspiration.",
      "3": "I am inspiring.",
      "4": "I am strongly inspiring.",
      "5": "I am legendary inspiration."
    },
    D5: {
      "1": "I am local only.",
      "2": "I am regional.",
      "3": "I am international.",
      "4": "I am global.",
      "5": "I am a global presence."
    },
    D6: {
      "1": "I have no disruption.",
      "2": "I have incremental innovation.",
      "3": "I have clear innovation.",
      "4": "I have strong disruption.",
      "5": "I am revolutionary."
    },
    D7: {
      "1": "I set no standards.",
      "2": "I set emerging standards.",
      "3": "I set clear standards.",
      "4": "I set strong standards.",
      "5": "I set legendary standards."
    },
    D8: {
      "1": "I have no ecosystem.",
      "2": "I have limited ecosystem.",
      "3": "I have good ecosystem.",
      "4": "I have strong ecosystem.",
      "5": "I have legendary ecosystem."
    },
    D9: {
      "1": "I create no change.",
      "2": "I create limited change.",
      "3": "I create some change.",
      "4": "I create strong change.",
      "5": "I create permanent change."
    }
  },
  L8: {
    D1: {
      "1": "I am extractive.",
      "2": "I have limited responsibility.",
      "3": "I have some responsibility.",
      "4": "I have strong responsibility.",
      "5": "I am an owner of stewardship."
    },
    D2: {
      "1": "I value only profits.",
      "2": "I value limited stakeholders.",
      "3": "I value good balance.",
      "4": "I value excellent value.",
      "5": "I value legendary value."
    },
    D3: {
      "1": "I am extractive.",
      "2": "I have some awareness.",
      "3": "I have good practices.",
      "4": "I have strong commitment.",
      "5": "I am transformative."
    },
    D4: {
      "1": "I have no social impact.",
      "2": "I have limited impact.",
      "3": "I have good impact.",
      "4": "I have strong impact.",
      "5": "I have transformative impact."
    },
    D5: {
      "1": "I am hidden.",
      "2": "I have limited visibility.",
      "3": "I have good governance.",
      "4": "I have strong governance.",
      "5": "I have legendary governance."
    },
    D6: {
      "1": "I am corrupt.",
      "2": "I have limited ethics.",
      "3": "I have good ethics.",
      "4": "I have strong ethics.",
      "5": "I have legendary ethics."
    },
    D7: {
      "1": "I exploit community.",
      "2": "I have limited partnership.",
      "3": "I have good partnership.",
      "4": "I have strong partnership.",
      "5": "I have transformative partnership."
    },
    D8: {
      "1": "I focus quarterly.",
      "2": "I focus annually.",
      "3": "I have 5–10 year view.",
      "4": "I have 20+ year view.",
      "5": "I have generational view."
    },
    D9: {
      "1": "I ignore values.",
      "2": "I have limited alignment.",
      "3": "I have good alignment.",
      "4": "I have strong alignment.",
      "5": "I have legendary alignment."
    }
  }
};

let updateCount = 0;
let missingCount = 0;

for (const [levelId, dimensions] of Object.entries(allUpdates)) {
  for (const [dimId, grades] of Object.entries(dimensions)) {
    if (!answerKeys[levelId]) {
      console.log(`Missing level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions) {
      console.log(`Missing questions in level: ${levelId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId]) {
      console.log(`Missing dimension: ${levelId} ${dimId}`);
      missingCount++;
      continue;
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders) {
      answerKeys[levelId].questions[dimId].stakeholders = {};
    }
    if (!answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER]) {
      answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER] = {
        question: "",
        grades: {}
      };
    }
    
    const stakeholderData = answerKeys[levelId].questions[dimId].stakeholders[STAKEHOLDER];
    if (!stakeholderData.grades) {
      stakeholderData.grades = {};
    }
    
    for (const [grade, answer] of Object.entries(grades)) {
      stakeholderData.grades[grade] = answer;
    }
    updateCount++;
    
    console.log(`Updated ${levelId} ${dimId} (5 grades)`);
  }
}

fs.writeFileSync(answerKeysPath, JSON.stringify(answerKeys, null, 2), 'utf-8');

console.log(`\n✅ Updated ${updateCount} Professional (Talent) entries with all 5 grades.`);
console.log(`⚠️ Missing entries: ${missingCount}`);
console.log(`Total individual grade updates: ${updateCount * 5}`);
console.log(`File saved to: ${answerKeysPath}`);
